// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/serial.mojom
//

package org.chromium.mojom.device.serial;

public final class HostControlSignals extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 16;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public boolean dtr;
    public boolean hasDtr;
    public boolean rts;
    public boolean hasRts;

    private HostControlSignals(int version) {
        super(STRUCT_SIZE, version);
        hasDtr = (boolean) false;
        hasRts = (boolean) false;
    }

    public HostControlSignals() {
        this(0);
    }

    public static HostControlSignals deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static HostControlSignals decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        HostControlSignals result = new HostControlSignals(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.dtr = decoder0.readBoolean(8, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.hasDtr = decoder0.readBoolean(8, 1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.rts = decoder0.readBoolean(8, 2);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.hasRts = decoder0.readBoolean(8, 3);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(dtr, 8, 0);
        encoder0.encode(hasDtr, 8, 1);
        encoder0.encode(rts, 8, 2);
        encoder0.encode(hasRts, 8, 3);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        HostControlSignals other = (HostControlSignals) object;
        if (this.dtr != other.dtr)
            return false;
        if (this.hasDtr != other.hasDtr)
            return false;
        if (this.rts != other.rts)
            return false;
        if (this.hasRts != other.hasRts)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(dtr);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(hasDtr);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(rts);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(hasRts);
        return result;
    }
}

